/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	MoviePlayer
**
** DESCRIPTION:	Header file for movie player
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef MOVIE_PLAYER_H
#define MOVIE_PLAYER_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "Flash/FlashPlayerInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CMoviePlayer
{
private:

	//class data
	IFlashPlayer *		m_pFlashPlayer;

	int					m_iWidth;
	int					m_iHeight;

	//class methods
	//setup
	public:		CMoviePlayer(void);
	public:		~CMoviePlayer(void);

	//process
	public:		const bool Play(const char *psMovieName, const int iWidth, const int iHeight);
	public:		void Draw(const ldwPoint sPos) const;
	public:		void Pause(void) const;
	public:		void Stop(void);// const;
	
	//access
	public:		const bool IsPlaying(void) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CMoviePlayer		MoviePlayer;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/